/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.hordes.common.ai;

import java.util.EnumSet;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.gen.Heightmap;
import net.smileycorp.atlas.api.util.DirectionUtils;

public class FleeEntityGoal
extends Goal {
    protected final MobEntity entity;
    protected final World world;
    protected final PathNavigator pather;
    protected int timeToRecalcPath = 0;
    protected float waterCost;
    protected final double speed;
    protected final double range;
    protected final Predicate<LivingEntity> predicate;

    public FleeEntityGoal(MobEntity entity, double speed, double range, Predicate<LivingEntity> predicate) {
        this.entity = entity;
        this.world = entity.field_70170_p;
        this.pather = entity.func_70661_as();
        this.predicate = predicate;
        this.speed = speed;
        this.range = range;
        this.func_220684_a(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE));
    }

    public boolean func_75250_a() {
        for (LivingEntity entity : this.getEntities()) {
            if (!this.entity.func_70685_l((Entity)entity)) continue;
            return true;
        }
        return false;
    }

    private List<LivingEntity> getEntities() {
        return this.world.func_175647_a(LivingEntity.class, new AxisAlignedBB(this.entity.func_226277_ct_() - this.range, this.entity.func_226278_cu_() - this.range, this.entity.func_226281_cx_() - this.range, this.entity.func_226277_ct_() + this.range, this.entity.func_226281_cx_() + this.range, this.entity.func_226281_cx_() + this.range), this.predicate);
    }

    public void func_75249_e() {
        this.waterCost = this.entity.func_184643_a(PathNodeType.WATER);
    }

    public boolean func_75253_b() {
        return true;
    }

    public void func_75251_c() {
        this.pather.func_75499_g();
        this.entity.func_184644_a(PathNodeType.WATER, this.waterCost);
    }

    public void func_75246_d() {
        if (--this.timeToRecalcPath <= 0) {
            this.timeToRecalcPath = 5;
            this.pather.func_75484_a(this.pather.func_225463_a(this.findSafePos(), 1), this.speed);
        }
    }

    private Stream<BlockPos> findSafePos() {
        Vector3d pos = this.entity.func_213303_ch();
        Vector3d resultDir = new Vector3d(0.0, 0.0, 0.0);
        for (LivingEntity entity : this.getEntities()) {
            if (!this.entity.func_70685_l((Entity)entity)) continue;
            Vector3d dir = DirectionUtils.getDirectionVecXZ((Entity)this.entity, (Entity)entity);
            resultDir = new Vector3d((dir.field_72450_a + resultDir.field_72450_a) / 2.0, (dir.field_72448_b + resultDir.field_72448_b) / 2.0, (dir.field_72449_c + resultDir.field_72449_c) / 2.0);
        }
        return Stream.of(this.world.func_205770_a(Heightmap.Type.WORLD_SURFACE, new BlockPos(pos.func_178787_e(resultDir.func_216371_e().func_216372_d(5.0, 0.0, 5.0)))));
    }
}

